﻿<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS DG-1</title>
		<script runat="server">

        static string traceName = "";

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            miesiąc = new YearMonth(Date.Today);
            miesiąc -= 1;
        }
    
        YearMonth miesiąc;
        [Required]
        [Priority(1)]
        public YearMonth ZaMiesiąc {
            get { return miesiąc; }
            set {
                miesiąc = value;
                OnChanged(EventArgs.Empty);
            }
        }    
	}

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
        //static bool debug = false;
        bool debug = false;
        [Priority(1)]
        [Caption("Liczby bez zaokrąglenia")]
        public bool Debug {
            get { return debug; }
            set {
                debug = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
        //przez listę a nie dla wszystkich
        //static bool wglisty = false;	
        bool wgListy = false;
        [Priority(2)]
        [Caption("Pracownicy wg listy")]
        public bool WgListy {
            get { return wgListy; }
            set {
                wgListy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool wgOkresu = true;
        [Priority(3)]
        [Caption("Elementy wg okresu LP")]
        public bool WgOkresu {
            get { return wgOkresu; }
            set {
                wgOkresu = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool bledy = false;
        [Priority(4)]
        [Caption("Pomiń błędne dane")]
        public bool Bledy {
            get { return bledy; }
            set {
                bledy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        string zapis = "";
        [Priority(5)]
        [Caption("Zapis obliczeń")]
        public string Zapis {
            get { return zapis; }
            set {
                zapis = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }	 
        
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set {
            srpars = value;
            traceName = srpars.Zapis;
        }
    }		
		            
    class Total {
        readonly SrParams srpars;
        public readonly FromTo rok;
        public readonly FromTo miesiąc;

        public int osobyMies;
        Time pracaRok;

        public decimal bruttoMies;
        public decimal skrMies;
        public decimal zusMies;
        
        public decimal bruttoRok;
        public decimal skrRok;
        public decimal zusRok;
    
        decimal[] wymiar = new decimal[12];
        int[] days = new int[12];
    
        public Total(YearMonth ym, SrParams srpars) {
            this.srpars = srpars;
            rok = new FromTo(new Date(ym.Year, 1, 1), ym.LastDay);
            miesiąc = ym.ToFromTo();

            int y = ym.Year;
            for (int m=1; m<=12; m++) {
                YearMonth c = new YearMonth(y, m);
                days[m-1] = c.Days;
            }
        }
    
        //Do etatów wliczamy pracowników (bez uczniów, chałupników, agentów i pracowników
        //zatrudnionych za granicą) --> RodzajZatrudnienia=Nie dotyczy
        //Pomijamy okresy urlopów bezpłatnych.

        public void AddEtaty(PracHistoria ph, KalkulatorPracy kalk, Periods eoz, ref List<WypElement> lista) {
            //-->Bez agentów, chałupników, uczniów
            if (ph.Etat.RodzajZatrudnienia!=RodzajZatrudnienia.NieDotyczy && ph.Etat.RodzajZatrudnienia!=RodzajZatrudnienia.PracownikTymczasowy)
                return;
    
            FromTo zatr = EfektywnyOkres(ph) * rok;
            if (zatr==FromTo.Empty)
                return;

			if (kalk!=null)
				pracaRok += kalk.Praca(zatr).Czas;
				
            decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
            Periods p = zatr.ToPeriods() * eoz;
            p = p.BreakByMonth();
            foreach (FromTo o in p) {
                int n = NieobecnyDni(ph.Pracownik, o);
                int m = o.From.Month-1;
                wymiar[m] += (w * (o.Days - n)) / days[m];
            }

            PlaceModule pl = PlaceModule.GetInstance(ph);
            SubTable elementy;
            if (srpars.WgOkresu)
                elementy = pl.WypElementy.WgOkresuListy[ph.Pracownik];
            else
                elementy = pl.WypElementy.WgPracownik[ph.Pracownik];
            FromTo okrz = srpars.WgOkresu ? new FromTo(zatr.From, zatr.To.LastDayMonth()) : zatr;
            elementy = new SubTable(elementy, okrz);
            foreach (WypElement e in elementy) {
                try {
                    if (lista.Contains(e)) continue;
                    if (e.Definicja.Info.Opodatkowany 
                        && !WypElement.Zasiłek.Eval(e) 
                        && e.Wyplata.Typ==TypWyplaty.Etat
                        && e.Definicja.GUS.WykazujNaDeklaracjach
                    ) {
                        bruttoRok += e.Wartosc;
                        bool skr = e.Definicja.GUS.Kategoria==KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku;
                        if (skr)
						    skrRok += e.Wartosc;
                        zusRok += e.Podatki.KosztyZUS;
                        if ((!srpars.WgOkresu && miesiąc.Contains(e.Okres.To)) ||
                            (srpars.WgOkresu && miesiąc.Contains(e.Wyplata.ListaPlac.Okres.To))) {
						    bruttoMies += e.Wartosc;
						    if (skr)
							    skrMies += e.Wartosc;
						    zusMies += e.Podatki.KosztyZUS;
                            Trace(e.Definicja + " " + e.Okres + " " + e.Wartosc);
                        }
                    }
                    lista.Add(e);
                }
                catch { Msg(); }
            }
        }

        public void AddOsoby(Pracownik p) {
            PracHistoria ph = p[miesiąc.To];
            if (ph.GUS.GlowneMiejscePracy && EfektywnyOkres(p, ph.Etat.EfektywnyOkres).Contains(miesiąc.To))
                switch (ph.Etat.RodzajZatrudnienia) {
                    case RodzajZatrudnienia.NieDotyczy:
                    case RodzajZatrudnienia.PracownikTymczasowy:
                    case RodzajZatrudnienia.PracownikZaGranicą:
                    case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                    case RodzajZatrudnienia.CzłonekRSP:
                    case RodzajZatrudnienia.CzłonekSKR:
                    case RodzajZatrudnienia.Chałupnik:
                    case RodzajZatrudnienia.Właściciel:
                    case RodzajZatrudnienia.OsobaWspółpracująca:
                    case RodzajZatrudnienia.WięzieńLubAresztowany:
                        //Agent
                        if (!Nieobecny(ph.Pracownik, miesiąc.To))
                            osobyMies++;
                        break;
                }
        }

        protected bool Nieobecny(Pracownik pracownik, Date data) {
            KalkulatorPracy kp = new KalkulatorPracy(pracownik);
            FromTo okres = new FromTo((new YearMonth(data) - 2).FirstDay, (new YearMonth(data) + 3).LastDay);

            Periods on = Periods.Empty;
            Periods on2 = Periods.Empty;
            foreach (INieobecnosc n in kp.Nieobecnosci(okres, false))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                        on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                        // urlop wychowawczy (zasiłek macierzyński)
                        if (n.Definicja.Guid == new Guid("00000000-0006-0005-0040-000000000000"))
                            on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                        on2 += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UsprawiedliwionaNiepłatna:
                        // urlop bezpłatny (art 174.1 kp)
                        // urlop bezpłatny (kod 350)
                        if (n.Definicja.Guid == new Guid("00000000-0006-0005-0010-000000000000") ||
                            n.Definicja.Guid == new Guid("00000000-0006-0005-0019-000000000000"))
                            on += n.Okres;
                        break;
                }

            //Nieobecności 'każdy dzień'
            if (on2[data] != FromTo.Empty)
                return true;

            on = on.ToFlat();
            okres = on[data];
            if (okres == FromTo.Empty)
                return false;
            StazPracy sp = new StazPracy(okres, pracownik).Normalizuj();
            return sp.Lata > 0 || sp.Miesiace > 2;
        }

        protected int NieobecnyDni(Pracownik pracownik, FromTo okres) {
            KalkulatorPracy kp = new KalkulatorPracy(pracownik);

            Periods on = Periods.Empty;
            foreach (INieobecnosc n in kp.Nieobecnosci(okres, true))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                    case PrzyczynaNieobecnosci.UrlopRodzicielski:
                    case PrzyczynaNieobecnosci.UrlopOjcowski:
                        on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UsprawiedliwionaNiepłatna:
                        // urlop bezpłatny (art 174.1 kp)
                        // urlop bezpłatny (kod 350)
                        if (n.Definicja.Guid == new Guid("00000000-0006-0005-0010-000000000000") ||
                            n.Definicja.Guid == new Guid("00000000-0006-0005-0019-000000000000"))
                            on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                        Nieobecnosc no = (Nieobecnosc)((OkresNieobecności)n);
                        foreach (WypElement we in no.Elementy) {
                            try {
                                if (we.Definicja.Nazwa.Contains("Zas. chorobowy") ||
                                    we.Definicja.Nazwa.Contains("Zas.chorob.") ||
                                    we.Definicja.Nazwa.Contains("Zas.chorobowy"))
                                    on += we.Okres * n.Okres;
                            }
                            catch { Msg(); }
                        }
                        break;
                }

            on = on.ToFlat();
            return on.Days;
        }
                            
        decimal EtatyOkres(int from, int to) {
            decimal w = 0;
            decimal m = to - from + 1;
            for (int i=from-1; i<to; i++)
                w += wymiar[i];
            w /= m;
            return w;
        }
        
        public decimal EtatyMies {
            get {
                decimal w = EtatyOkres(rok.To.Month, rok.To.Month);
                return System.Math.Round(w, srpars.Debug ? 2 : 0);
            }
        }

        public decimal EtatyRok {
			get { 
                decimal w = EtatyOkres(1, rok.To.Month);
                return System.Math.Round(w, srpars.Debug ? 2 : 0);
            }
        }
    		
        public decimal Czas {
            get {
                decimal t = (decimal)pracaRok.TotalHours;
                if (srpars.Debug)
                    return t;
                return Soneta.Tools.Math.Round(t / 1000, 1);
            }
        }
	}

    public decimal Tys(decimal value) {
        if (srpars.Debug)
            return value;
        return Soneta.Tools.Math.Round(value / 1000, 1);
    }

    Dictionary<object, List<Pracownik>> dict = new Dictionary<object, List<Pracownik>>();
    static Log trace;
    string title;
    Log log;
    	    
    void dc_ContextLoad(Object sender, EventArgs e) {
        ReportHeader["MIESIĄC"] = pars.ZaMiesiąc.ToString();
        title = ReportHeader.Title;

        log = new Log("Zestawienie DG-1", true);
        trace = null;
        if (traceName != "")
            trace = new Log(traceName, true);        
        
        KadryModule kadry = KadryModule.GetInstance(dc);
        IEnumerable pracownicy;
        if (srpars.WgListy) {
            ArrayList lista = new ArrayList();
            foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                lista.Add(idx);
            pracownicy = lista;
        }
        else {
            Soneta.Business.View view = kadry.Pracownicy.CreateView();
            view.ForceAllRows();
            pracownicy = view;
        }

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.ZaMiesiąc.LastDay;
            foreach (Pracownik pracownik in pracownicy) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.ZUS == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(string.Empty, list = new List<Pracownik>());
            foreach (Pracownik pracownik in pracownicy)
                list.Add(pracownik);
        }

        DataRepeater1.DataSource = dict.Keys;
    }

	void OnBeforeRow(Object sender, EventArgs args) {
        report = ReportHeader;

        object of = DataRepeater1.CurrentRow;
        if (of is OddzialFirmy)
            report.Title = title.Replace("%ODDZIAL%", "Oddział: " + of);
        else
            report.Title = title.Replace("%ODDZIAL%", "");

        bool czas = (pars.ZaMiesiąc.Month%3)==0;
        Total t = new Total(pars.ZaMiesiąc, srpars);
        int l = 0;
        int m = dict[of].Count;

        foreach (Pracownik p in dict[of]) {
            Trace(p);
            //log.WriteLine(new Percent(++l, m));
            log.WriteLine(p);
            using (trace == null ? null : trace.IncrementIndent()) {
                List<WypElement> lista = new List<WypElement>();
                try {
                    KalkulatorPracy kalk = new KalkulatorPracy(p);
                    Periods eoz = EfektywnyOkresZatrudnienia(p, kalk, t.rok);
                    foreach (PracHistoria ph in p.Historia.GetIntersectedRows(EfektywnyOkres(p, t.rok)))
                        t.AddEtaty(ph, czas ? kalk : null, eoz, ref lista);
                    t.AddOsoby(p);
                }
                catch (Exception ex) {
                    if (!srpars.Bledy)
                        throw new Exception(ex.Message);
                    log.WriteLine("błąd: " + ex.Message);
                }
            }
        }
        
        osobyMies.EditValue = t.osobyMies;
                
        etatyMies.EditValue = t.EtatyMies;
        etatyRok.EditValue = t.EtatyRok;
        
        pracaRok.EditValue = czas ? t.Czas.ToString() : "&nbsp;";
        
        bruttoMies.EditValue = Tys(t.bruttoMies);
        bruttoRok.EditValue = Tys(t.bruttoRok);
        
        skrMies.EditValue = Tys(t.skrMies);
        skrRok.EditValue = Tys(t.skrRok);
        
        //zusMies.EditValue = czas ? Tys(t.zusMies).ToString() : "&nbsp;";
        zusRok.EditValue = czas ? Tys(t.zusRok).ToString() : "&nbsp;";
    }

    Periods EfektywnyOkresZatrudnienia(Pracownik pracownik, KalkulatorPracy kalk, FromTo okres) {
        //Wyliczamy okres zatrudnienia w bieżącym miesiącu
        Periods okrzatr = Periods.Empty;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(EfektywnyOkres(pracownik, okres)))
            okrzatr += EfektywnyOkres(ph);
        okrzatr *= okres;

        Periods on = Periods.Empty;
        foreach (INieobecnosc n in kalk.Nieobecnosci(okres, false))
            switch (n.Definicja.Przyczyna) {
                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    on += n.Okres;
                    break;
            }

        okrzatr -= on;
        return okrzatr.ToFlat();
    }

    static FromTo EfektywnyOkres(Pracownik p, FromTo okres) {
        foreach (PracHistoria ph in p.Historia.GetIntersectedRows(new FromTo(okres.From, Date.MaxValue)))
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty) {
                Date dt = okres.To != Date.Empty ? okres.To : Date.MaxValue;
                if (ph.Etat.DataPrzejeciaPracownika <= dt)
                    okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, dt);
                else
                    okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, Date.MaxValue);
                break;
            }
        return okres;
    }
    
    static FromTo EfektywnyOkres(PracHistoria ph) {
        FromTo okres = ph.Etat.EfektywnyOkres;
        if (ph.Etat.DataPrzejeciaPracownika != Date.Empty)
            okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, Date.MaxValue);
        return okres;
    }
		        
    static void Msg(object value) {
    }

    static void Trace(object value) {
        if (trace != null)
            trace.WriteLine(value == null ? "(null)" : value.ToString());
    }

    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }
		        
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="Form1" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" onbeforerow="OnBeforeRow">
            <ea:PageBreak ID="PageBreak6" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
            <eb:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS DG-1|Meldunek o działalności gospodarczej|</strong>Za miesiąc: <strong>%MIESIĄC%|%ODDZIAL%" runat="server"></eb:reportheader>
			<font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 1. Podstawowe dane o działalności gospodarczej</font>
				<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    
                style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD style="WIDTH: 486px" width="486" colSpan="3">
							<P align="center">Wyszczególnienie</P>
						</TD>
						<TD width="20%">
							<P align="center">W miesiącu sprawozdawczym</P>
						</TD>
						<TD>
							<P align="center">Od początku roku do końca miesiąca sprawozdawczego</P>
						</TD>
					</TR>
					<TR>
						<TD style="WIDTH: 486px; HEIGHT: 13px" width="486" colSpan="3">
							<P align="center"><FONT size="2">0</FONT></P>
						</TD>
						<TD style="HEIGHT: 13px" width="20%">
							<P align="center"><FONT size="2">1</FONT></P>
						</TD>
						<TD style="HEIGHT: 13px">
							<P align="center"><FONT size="2">2</FONT></P>
						</TD>
					</TR>
					<TR>
						<TD width="56%" colSpan="2" height="42">Pracujący w osobach, dla których jednostka sprawozdawcza jest głównym miejscem pracy,
                            stan w ostatnim dniu miesiąca</TD>
						<TD height="42">
							<P align="center">06</P>
						</TD>
						<TD width="20%" height="42">
							<P align="right"><ea:datalabel id="osobyMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right">&nbsp;</P>
						</TD>
					</TR>
					<TR>
						<TD colSpan="2" height="42">Przeciętna liczba zatrudnionych</TD>
						<TD height="42">
							<P align="center">07</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="etatyMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="etatyRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD colSpan="2" height="42">Czas faktycznie przepracowany w tyś. godz. (wypełnić za miesiąc: 
							III, VI, IX, XII - za okres od początku roku)</TD>
						<TD height="42">
							<P align="center">08</P>
						</TD>
						<TD height="42">
							<P align="right">&nbsp;</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="pracaRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD colSpan="2" height="42">Wynagrodzenie brutto osób wykazanych w wierszu 07 w 
							tyś. zł</TD>
						<TD height="42">
							<P align="center">09</P>
						</TD>
						<TD height="42">
							<P align="right">
								<ea:DataLabel id="bruttoMies" runat="server"></ea:DataLabel></P>
						</TD>
						<TD height="42">
							<P align="right">
								<ea:DataLabel id="bruttoRok" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD width="10%" height="42" rowSpan="2">z&nbsp;wiersza<BR>
							09 przypa-<BR>
							da na</TD>
						<TD height="42">wypłaty z tytułu udziału w zysku lub nadwyżce<BR>
							bilansowej w spółdzielniach</TD>
						<TD style="WIDTH: 23px" height="42">
							<P align="center">10</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="skrMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="skrRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD height="42">składki na ubezpieczenia emerytalne, rentowe i chorobowe opłacane przez ubezpieczonych<br />
                        (wypełnić za miesiąc: III, VI, IX, XII - za okres od początku roku)</TD>
						<TD style="WIDTH: 23px" height="42">
							<P align="center">11</P>
						</TD>
						<TD height="42">
							<P align="right">&nbsp;</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="zusRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					</TABLE>
			<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
